<?php
include('config.php');

// Connect to the database
$conn = mysqli_connect($hostname, $username, $password, $database);
if (!$conn) {
    echo "Database Not Connected: " . mysqli_connect_error();
    exit; // Exit if database connection fails
}

$order_id = isset($_COOKIE['transaction_number']) ? $_COOKIE['transaction_number'] : '';
$userid = isset($_SESSION['userid']) ? $_SESSION['userid'] : '';

$url = "https://getaway.alampay.in/api/check-order-status";

$postData = array(
    "user_token" => "2a4d5e7b2b958bb420da240f7c264a2b",
    "order_id" => $order_id
);

$ch = curl_init($url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($postData));
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/x-www-form-urlencoded'
]);

$response = curl_exec($ch);

if (curl_errno($ch)) {
    echo "cURL Error: " . curl_error($ch);
    curl_close($ch);
    exit;
}
curl_close($ch);

$responseData = json_decode($response, true);

if ($responseData && isset($responseData["status"]) && $responseData["status"] === true) {
    $txnStatus = $responseData["result"]["txnStatus"];
    $orderId = $responseData["result"]["orderId"];
    $amount = $responseData["result"]["amount"];
    $utr = $responseData["result"]["utr"]; // Retrieve the UTR
    $phone = isset($_SESSION['phone']) ? $_SESSION['phone'] : '';

    // Check if the transaction is already marked as success
    $stmt = $conn->prepare("SELECT status FROM qrtxn WHERE phone = ? AND txnid = ?");
    $stmt->bind_param("ss", $phone, $orderId);
    $stmt->execute();
    $stmt->bind_result($currentStatus);
    $stmt->fetch();
    $stmt->close();

    if ($currentStatus === 'success') {
        // Transaction already processed, set notification and redirect
        $_SESSION['notification'] = "Transaction already processed. No further action required.";
        header("Location: https://uiducl.info/admin/wallet.php");
        exit;
    } else {
        // Update wallet table and BANKTXNID with UTR
        $stmt = $conn->prepare("UPDATE qrtxn SET status = 'success', txnid = ? WHERE phone = ? AND txnid = ?");
        $stmt->bind_param("sss", $utr, $phone, $orderId); // Bind UTR to BANKTXNID

        if ($stmt->execute()) {
            echo "Wallet table updated successfully";

            // Update balance in users table
            $stmt = $conn->prepare("UPDATE usertable SET walletamount = walletamount + ? WHERE phone = ?");
            $stmt->bind_param("ds", $amount, $phone);

            if ($stmt->execute()) {
                // Get the new balance
                $stmt = $conn->prepare("SELECT walletamount FROM usertable WHERE phone = ?");
                $stmt->bind_param("s", $phone);
                $stmt->execute();
                $stmt->bind_result($nbal);
                $stmt->fetch();
                $stmt->close();

                // Update qrtxn table if transaction successful
                $stmt = $conn->prepare("UPDATE qrtxn SET status = 'success' WHERE txnid = ? AND status = 'pending'");
                $stmt->bind_param("s", $orderId);

                
                    if ($stmt->execute()) {
                        $_SESSION['payment_success'] = true;
                        header("Location: https://uiducl.info/admin/wallet.php");
                        exit;
                    } else {
                        echo "Error inserting into wallethistory: " . $stmt->error;
                    }
                } else {
                echo "Error updating user balance: " . $stmt->error;
            }
        } else {
            echo "Error updating wallet table: " . $stmt->error;
        }
    }
} else {
    echo "Transaction is not completed or API call failed.";
}

$conn->close();
?>
