<?php
session_start();

/* === DB CONFIG === */
$db_host = "localhost";   // DB Host
$db_user = "u213768140_ucl";        // DB Username
$db_pass = "Biki@733102";            // DB Password
$db_name = "u213768140_ucl";      // DB Name

$conn = new mysqli($db_host, $db_user, $db_pass, $db_name);
if ($conn->connect_error) die("DB Connection failed: " . $conn->connect_error);

$alert = '';

/* ===== REGISTER ===== */
if (isset($_POST['register'])) {
    $name = trim($_POST['name']);
    $phone = trim($_POST['phone']);
    $email = trim($_POST['email']);
    $state = trim($_POST['state']);
    $city = trim($_POST['city']);
    $pass = $_POST['password'];
    $cpass = $_POST['cpassword'];

    if ($pass !== $cpass) {
        $alert = "error|Passwords do not match!";
    } else {
        $userid = "U".time();
        $hash = password_hash($pass, PASSWORD_DEFAULT);

        $stmt = $conn->prepare("INSERT INTO usertable (name, phone, emailid, userid, password, state, city) VALUES (?,?,?,?,?,?,?)");
        $stmt->bind_param("sssssss",$name,$phone,$email,$userid,$hash,$state,$city);
        if($stmt->execute()){
            $alert = "success|Registration successful! Your UserID: $userid";
        } else {
            $alert = "error|Registration failed (Maybe duplicate Email/Phone)";
        }
        $stmt->close();
    }
}

/* ===== LOGIN ===== */
if (isset($_POST['login'])) {
    $id = trim($_POST['identifier']);
    $pass = $_POST['password'];

    $stmt = $conn->prepare("SELECT * FROM usertable WHERE emailid=? OR phone=? OR userid=? LIMIT 1");
    $stmt->bind_param("sss",$id,$id,$id);
    $stmt->execute();
    $res = $stmt->get_result();
    if($row = $res->fetch_assoc()){
        // check both hash + plain (for old data)
        if(password_verify($pass, $row['password']) || $pass === $row['password']){
            $_SESSION['uid']=$row['id'];
            $_SESSION['name']=$row['name'];
            $_SESSION['userid']=$row['userid'];
            $alert = "success|Welcome ".$row['name']."!|admin/index.php";
        } else {
            $alert = "error|Incorrect password!";
        }
    } else {
        $alert = "error|User not found!";
    }
    $stmt->close();
}

/* ===== FORGOT VERIFY ===== */
if (isset($_POST['forgot'])) {
    $name = trim($_POST['fname']);
    $phone = trim($_POST['fphone']);
    $email = trim($_POST['femail']);

    $stmt = $conn->prepare("SELECT * FROM usertable WHERE name=? AND phone=? AND emailid=? LIMIT 1");
    $stmt->bind_param("sss",$name,$phone,$email);
    $stmt->execute();
    $res = $stmt->get_result();
    if($row = $res->fetch_assoc()){
        $_SESSION['reset_id']=$row['id'];
        $alert = "success|Verified! Now set new password below.";
    } else {
        $alert = "error|No matching user found!";
    }
}

/* ===== RESET PASSWORD ===== */
if (isset($_POST['reset'])) {
    if(!isset($_SESSION['reset_id'])) $alert = "error|First verify your details!";
    else {
        $new = $_POST['newpass'];
        $cnew = $_POST['cnewpass'];
        if($new!==$cnew) $alert = "error|Passwords not matching!";
        else{
            $hash = password_hash($new, PASSWORD_DEFAULT);
            $stmt = $conn->prepare("UPDATE usertable SET password=? WHERE id=?");
            $stmt->bind_param("si",$hash,$_SESSION['reset_id']);
            if($stmt->execute()){
                unset($_SESSION['reset_id']);
                $alert = "success|Password reset successful! You can login now.";
            } else $alert = "error|Error updating password!";
        }
    }
}
?>
<!DOCTYPE html>
<html>
<head>
<title>Login System</title>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<style>
body{font-family:Arial;background:linear-gradient(135deg,#74b9ff,#a29bfe);margin:0;display:flex;justify-content:center;align-items:center;height:100vh}
.container{background:#fff;padding:25px;border-radius:12px;width:380px;box-shadow:0 8px 25px rgba(0,0,0,0.15);text-align:center}
h2{color:#2d3436;margin-bottom:15px}
input,button{width:100%;padding:12px;margin:6px 0;border:1px solid #ccc;border-radius:8px;font-size:14px}
button{background:#0984e3;color:#fff;border:none;cursor:pointer}
button:hover{background:#74b9ff}
.link{margin-top:10px;font-size:13px}
a{color:#0984e3;cursor:pointer;text-decoration:none}
</style>
</head>
<body>
<div class="container" id="loginbox">
    <h2>Sign In</h2>
    <form method="post">
        <input type="text" name="identifier" placeholder="UserID / Email / Phone" required>
        <input type="password" name="password" placeholder="Password" required>
        <button type="submit" name="login">Sign In</button>
    </form>
    <div class="link"><a onclick="show('register')">Create Account</a> | <a onclick="show('forgot')">Forgot?</a></div>
</div>

<div class="container" id="register" style="display:none">
    <h2>Create Account</h2>
    <form method="post">
        <input type="text" name="name" placeholder="Full Name" required>
        <input type="text" name="phone" placeholder="Mobile Number" required>
        <input type="email" name="email" placeholder="Email Address" required>
        <input type="text" name="state" placeholder="State">
        <input type="text" name="city" placeholder="City">
        <input type="password" name="password" placeholder="Password" required>
        <input type="password" name="cpassword" placeholder="Confirm Password" required>
        <button type="submit" name="register">Register</button>
    </form>
    <div class="link"><a onclick="show('loginbox')">Already have account?</a></div>
</div>

<div class="container" id="forgot" style="display:none">
    <h2>Forgot Password</h2>
    <form method="post">
        <input type="text" name="fname" placeholder="Full Name" required>
        <input type="text" name="fphone" placeholder="Mobile Number" required>
        <input type="email" name="femail" placeholder="Email Address" required>
        <button type="submit" name="forgot">Verify Details</button>
    </form>
    <form method="post">
        <input type="password" name="newpass" placeholder="New Password">
        <input type="password" name="cnewpass" placeholder="Confirm Password">
        <button type="submit" name="reset">Reset Password</button>
    </form>
    <div class="link"><a onclick="show('loginbox')">Back to login</a></div>
</div>

<?php if (!empty($alert)):
  $parts = explode('|',$alert);
  $type = $parts[0];
  $message = $parts[1];
  $redirect = $parts[2] ?? '';
?>
<script>
Swal.fire({
  icon: '<?= $type ?>',
  title: '<?= ucfirst($type) ?>',
  text: '<?= $message ?>',
  <?php if ($type === 'success' && $redirect): ?>
    timer: 1500,
    timerProgressBar: true,
    didClose: () => { window.location.href = '<?= $redirect ?>'; }
  <?php endif; ?>
});
</script>
<?php endif; ?>

<script>
function show(id){
    document.querySelectorAll('.container').forEach(c=>c.style.display='none');
    document.getElementById(id).style.display='block';
}
</script>
</body>
</html>
