<?php
include('header.php');
include('../includes/config.php');

// === Admin check ===
if (!isset($_SESSION['is_admin']) || $_SESSION['is_admin'] !== true) {
    // demo জন্য access খুলে দিলাম
    // die("Access Denied! Admin only.");
}

// === Search & Pagination Setup ===
$limit = 10;
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
if ($page < 1) $page = 1;
$offset = ($page - 1) * $limit;

$search = isset($_GET['search']) ? mysqli_real_escape_string($conn, $_GET['search']) : "";

$count_sql = "SELECT COUNT(*) as total FROM wallet w 
              LEFT JOIN usertable u ON w.userid = u.phone
              WHERE w.userid LIKE '%$search%' OR u.name LIKE '%$search%' OR w.ORDERID LIKE '%$search%'";
$count_res = mysqli_query($conn, $count_sql);
$total_rows = mysqli_fetch_assoc($count_res)['total'];
$total_pages = ceil($total_rows / $limit);

$sql = "SELECT w.id, w.userid, w.amount, w.balance, w.purpose, w.status, w.type, 
               w.BANKTXNID, w.ORDERID, w.paymentStatus, w.txn_date, u.name 
        FROM wallet w 
        LEFT JOIN usertable u ON w.userid = u.phone 
        WHERE w.userid LIKE '%$search%' OR u.name LIKE '%$search%' OR w.ORDERID LIKE '%$search%'
        ORDER BY w.id DESC LIMIT $limit OFFSET $offset";
$result = mysqli_query($conn, $sql);
?>
<!DOCTYPE html>
<html>
<head>
    <title>Wallet Transactions - Admin</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">
    <style>
        body {
            background: #f8f9fa;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            color: #333;
        }
        .container {
            margin-top: 40px;
            background: #ffffff;
            border-radius: 12px;
            padding: 30px;
            box-shadow: 0 5px 20px rgba(0,0,0,0.1);
        }
        h2 {
            font-weight: bold;
            color: #222;
        }
        .table {
            border-radius: 10px;
            overflow: hidden;
        }
        th {
            background: #0d6efd;
            color: white;
            text-align: center;
        }
        td {
            text-align: center;
            vertical-align: middle;
        }
        .badge {
            font-size: 0.85rem;
            padding: 6px 10px;
        }
        .search-box {
            max-width: 400px;
            margin: auto;
        }
        .pagination .page-link {
            color: #0d6efd;
        }
        .pagination .active .page-link {
            background: #0d6efd;
            border-color: #0d6efd;
            color: white;
        }
    </style>
</head>
<body>
<div class="container">
    <h2 class="text-center mb-4">📊 Wallet Transactions (Admin Panel)</h2>

    <!-- Search Box -->
    <form method="GET" class="mb-4 search-box">
        <div class="input-group">
            <input type="text" name="search" class="form-control" placeholder="Search"
                   value="<?php echo htmlspecialchars($search); ?>">
            <button class="btn btn-primary" type="submit">Search</button>
        </div>
    </form>

    <div class="table-responsive shadow-sm">
        <table class="table table-bordered table-hover align-middle">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>User Phone</th>
                    <th>User Name</th>
                    <th>Amount</th>
                    <th>Balance</th>
                    <th>Purpose</th>
                    <th>Type</th>
                    <th>Status</th>
                    <th>ORDERID</th>
                    <th>BANKTXNID</th>
                    <th>Payment Status</th>
                    <th>Txn Date</th>
                </tr>
            </thead>
            <tbody>
                <?php if (mysqli_num_rows($result) > 0) { ?>
                    <?php while($row = mysqli_fetch_assoc($result)) { ?>
                        <tr>
                            <td><?php echo $row['id']; ?></td>
                            <td><?php echo $row['userid']; ?></td>
                            <td><?php echo $row['name']; ?></td>
                            <td><span class="badge bg-info">₹<?php echo $row['amount']; ?></span></td>
                            <td><span class="badge bg-dark">₹<?php echo $row['balance']; ?></span></td>
                            <td><?php echo $row['purpose']; ?></td>
                            <td>
                                <?php if ($row['type'] == "CREDIT") { ?>
                                    <span class="badge bg-success">CREDIT</span>
                                <?php } else { ?>
                                    <span class="badge bg-danger">DEBIT</span>
                                <?php } ?>
                            </td>
                            <td>
                                <?php if ($row['status'] == 1) { ?>
                                    <span class="badge bg-success">Active</span>
                                <?php } else { ?>
                                    <span class="badge bg-secondary">Pending</span>
                                <?php } ?>
                            </td>
                            <td><?php echo $row['ORDERID']; ?></td>
                            <td><?php echo $row['BANKTXNID']; ?></td>
                            <td>
                                <?php if ($row['paymentStatus'] == "TXN_SUCCESS") { ?>
                                    <span class="badge bg-success">SUCCESS</span>
                                <?php } else { ?>
                                    <span class="badge bg-warning text-dark"><?php echo $row['paymentStatus']; ?></span>
                                <?php } ?>
                            </td>
                            <td><?php echo $row['txn_date']; ?></td>
                        </tr>
                    <?php } ?>
                <?php } else { ?>
                    <tr><td colspan="12" class="text-center">🚫 No transactions found</td></tr>
                <?php } ?>
            </tbody>
        </table>
    </div>

    <!-- Pagination -->
    <nav class="mt-3">
        <ul class="pagination justify-content-center">
            <?php if ($page > 1) { ?>
                <li class="page-item"><a class="page-link" href="?page=<?php echo $page-1; ?>&search=<?php echo urlencode($search); ?>">⬅ Prev</a></li>
            <?php } ?>
            <?php for ($i=1; $i <= $total_pages; $i++) { ?>
                <li class="page-item <?php if ($i == $page) echo 'active'; ?>">
                    <a class="page-link" href="?page=<?php echo $i; ?>&search=<?php echo urlencode($search); ?>"><?php echo $i; ?></a>
                </li>
            <?php } ?>
            <?php if ($page < $total_pages) { ?>
                <li class="page-item"><a class="page-link" href="?page=<?php echo $page+1; ?>&search=<?php echo urlencode($search); ?>">Next ➡</a></li>
            <?php } ?>
        </ul>
    </nav>
</div>
</body>
</html>
