<?php
include('header.php');
include('../includes/config.php');

$data = [
    "eid" => "",
    "edate" => "",
    "etime" => "",
    "name" => "",
    "fname" => "",
    "village" => "",
    "block" => "",
    "district" => "",
    "state" => "",
    "pincode" => "",
    "dob" => "",
    "mobile_no" => "",
    "email" => "",
    "purpose" => "",
    "status" => "",
    "poi" => ""
];

if (isset($_GET['id'])) {
    $id = intval($_GET['id']);
    $sql = "SELECT * FROM dob WHERE id = $id";
    $result = mysqli_query($conn, $sql);
    if ($result && mysqli_num_rows($result) > 0) {
        $data = mysqli_fetch_assoc($result);
    }
}

$photoPath = "../uploads/" . $data['poi'];
$imgPath = "";

if (!empty($data['poi'])) {
    $ext = strtolower(pathinfo($photoPath, PATHINFO_EXTENSION));
    if (in_array($ext, ["jpg","jpeg","png"])) {
        $imgPath = $photoPath;
    }
}
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Aadhaar Slip</title>
    <style>
        body { font-family: Arial, sans-serif; }
        .slip { border:1px solid #000; padding:15px; width:700px; margin:20px auto; background:#fff; }
        .header { display:flex; justify-content:space-between; align-items:flex-start; }
        .photo { border:1px solid #000; width:120px; height:140px; text-align:center; display:flex; align-items:center; justify-content:center; }
        .photo img { max-width:100%; max-height:100%; }
        table { width:100%; border-collapse:collapse; margin-top:10px; }
        td { border:1px solid #000; padding:5px; vertical-align:top; }
        .label { font-weight:bold; width:200px; background:#f9f9f9; }
        .btn-container { text-align:center; margin-top:20px; }
        .btn {
            background:#007bff;
            color:#fff;
            padding:10px 20px;
            text-decoration:none;
            border-radius:5px;
            font-weight:bold;
            margin:5px;
            display:inline-block;
        }
        .btn:hover { background:#0056b3; }
    </style>
</head>
<body>
<div id="slip" class="slip">
    <div class="header">
        <div>
            <p><b>Enrolment No.:</b> <?= htmlspecialchars($data['eid']) ?></p>
            <p><b>Date:</b> <?= htmlspecialchars($data['edate']) ?> 
               &nbsp; <b>Time:</b> <?= htmlspecialchars($data['etime']) ?></p>
        </div>
        <div class="photo">
            <?php if (!empty($imgPath)): ?>
                <img src="<?= $imgPath ?>" alt="Photo">
            <?php else: ?>
                PHOTO
            <?php endif; ?>
        </div>
    </div>
    <table>
        <tr><td class="label">Name</td><td><?= htmlspecialchars($data['name']) ?></td></tr>
        <tr><td class="label">GENDER</td><td><?= htmlspecialchars($data['fname']) ?></td></tr>
        <tr>
          <td class="label">Address</td>
          <td>
            <?= htmlspecialchars($data['village']) ?>, 
            <?= htmlspecialchars($data['block']) ?>, 
            <?= htmlspecialchars($data['district']) ?>, 
            <?= htmlspecialchars($data['state']) ?> - 
            <?= htmlspecialchars($data['pincode']) ?>
          </td>
        </tr>
        <tr><td class="label">OLD DOB</td><td><?= htmlspecialchars($data['email']) ?></td></tr>
        <tr><td class="label">NEW DOB</td><td><?= htmlspecialchars($data['dob']) ?></td></tr>
        <tr><td class="label">Mobile</td><td><?= htmlspecialchars($data['mobile_no']) ?></td></tr>
        <tr><td class="label">Purpose</td><td><?= htmlspecialchars($data['purpose']) ?></td></tr>
        <tr><td class="label">Status</td><td><?= htmlspecialchars($data['status']) ?></td></tr>
    </table>
</div>

<!-- Buttons -->
<div class="btn-container">
    <a href="https://myaadhaar.uidai.gov.in/CheckAadhaarStatus/en" target="_blank" class="btn">
        CHECK AADHAAR UPDATE STATUS
    </a>
    <a href="#" onclick="downloadPDF()" class="btn">
        DOWNLOAD SLIP
    </a>
</div>

<!-- Libraries -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
<script>
function downloadPDF() {
    const { jsPDF } = window.jspdf;
    const slip = document.getElementById("slip");

    html2canvas(slip).then(canvas => {
        const imgData = canvas.toDataURL("image/png");
        const pdf = new jsPDF("p", "mm", "a4");
        const pageWidth = pdf.internal.pageSize.getWidth();
        const pageHeight = pdf.internal.pageSize.getHeight();
        const imgWidth = pageWidth - 20;
        const imgHeight = canvas.height * imgWidth / canvas.width;

        pdf.addImage(imgData, "PNG", 10, 10, imgWidth, imgHeight);
        pdf.save("Aadhaar_Slip.pdf");
    });
}
</script>
</body>
</html>
