<?php
// Enable error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Start session
session_start();

include '../../includes/database.php';

// Get session email id
if (isset($_SESSION['emailid'])) {
    $emailid = $_SESSION['emailid'];
} else {
    echo "Email ID not found in session";
    exit; // Exit if session email ID is not set
}

// Get session phone number
if (isset($_POST['phone'])) {
    $phone = $_POST['phone'];
} else {
    echo "Phone number not found in session";
    exit; // Exit if session phone number is not set
}

// Fetch user_token directly from the website table
$token_query = "SELECT user_token FROM website LIMIT 1";
$token_result = mysqli_query($conn, $token_query);

if ($token_result && mysqli_num_rows($token_result) > 0) {
    $token_row = mysqli_fetch_assoc($token_result);
    $user_token = $token_row['user_token'];
} else {
    echo "User token not found in the website table.";
    exit; // Exit if user token is not found
}

// Generate transaction number
$txn_number = uniqid() . time();

// Fetch user_token directly from the website table
$upi_query = "SELECT upi FROM website LIMIT 1";
$upi_result = mysqli_query($conn, $upi_query);

if ($upi_result && mysqli_num_rows($upi_result) > 0) {
    $upi_row = mysqli_fetch_assoc($upi_result);
    $upi = $upi_row['upi'];
} else {
    echo "User upi not found in the website table.";
    exit; // Exit if user token is not found
}


// UPI from POST data
$upi = $upi;

// Amount from POST data
$amount = isset($_POST['amount']) ? mysqli_real_escape_string($conn, $_POST['amount']) : '';

// Insert transaction into database
$res = mysqli_query($conn, "INSERT INTO `qrtxn`(`phone`, `emailid`, `amount`, `txnid`, `upi`, `status`) VALUES ('$phone','$emailid','$amount','$txn_number','$upi','pending')");
if (!$res) {
    echo "Error inserting transaction into database: " . mysqli_error($conn);
    exit; // Exit if transaction insertion fails
}

// Set cookie for transaction number
setcookie("transaction_number", $txn_number, time() + 3600, "/"); // Expires in 1 hour

// Generate dynamic callback URL
$protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http";
$host = $_SERVER['HTTP_HOST'];
$path = dirname($_SERVER['PHP_SELF']);
$callback_url = $protocol . "://" . $host . $path . "/callback.php";

// URL of the PHP page
$url = 'https://ashudigitalpay.viewscert.in/api/create-order';

// Data to be sent in the POST request
$data = array(
    'customer_mobile' => $phone,
    'user_token' => $user_token, // Use the fetched user token
    'amount' => $amount,
    'order_id' => $txn_number,
    'redirect_url' => $callback_url,
    'remark1' => $phone,
    'remark2' => 'test2',
    'route' => '1' // route 2 is for VIP users, route 1 is for normal users
);

// Initialize cURL session
$ch = curl_init();

// Set cURL options
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_POST, 1);
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

// Execute cURL session and store the response
$response = curl_exec($ch);

// Check for cURL errors
if (curl_errno($ch)) {
    echo 'cURL Error: ' . curl_error($ch);
    exit; // Exit if cURL error occurs
}

// Close cURL session
curl_close($ch);

// Decode the JSON response
$jsonResponse = json_decode($response, true);

// Check if decoding was successful
if ($jsonResponse !== null) {
    // Redirect the user to the payment URL
    if (isset($jsonResponse['result']['payment_url'])) {
        $paymentUrl = $jsonResponse['result']['payment_url'];
        header('Location: ' . $paymentUrl);
        exit;
    } else {
        echo 'Payment URL not found in JSON response.';
        exit; // Exit if payment URL not found in JSON response
    }
} else {
    echo 'Failed to decode JSON response.';
    exit; // Exit if decoding JSON response fails
}
?>
