<?php
session_start();
header('Content-Type: text/html; charset=utf-8');

// --- DB Connection ---
$host = "localhost";
$user = "u213768140_demo";      // আপনার DB username
$pass = "Biki@733102";          // আপনার DB password
$db   = "u213768140_demo";      // আপনার DB নাম

$conn = mysqli_connect($host, $user, $pass, $db);
if (!$conn) {
    die("DB Connection failed: " . mysqli_connect_error());
}

// --- Helpers ---
function currencyINR($n) {
    return '₹' . number_format($n, 0, '.', ',');
}
function find_product($conn, $id) {
    $res = mysqli_query($conn, "SELECT * FROM products WHERE id=$id");
    return mysqli_fetch_assoc($res);
}

// --- Init Cart ---
if (!isset($_SESSION['cart'])) $_SESSION['cart'] = [];

// --- Handle Actions ---
$flash = null;
$action = $_REQUEST['action'] ?? '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if ($action === 'add_to_cart' && !empty($_POST['productId'])) {
        $pid = intval($_POST['productId']);
        $qty = max(1, intval($_POST['qty'] ?? 1));
        $p = find_product($conn, $pid);
        if ($p) {
            $cur = $_SESSION['cart'][$pid] ?? 0;
            $new = min($cur + $qty, $p['stock']);
            $_SESSION['cart'][$pid] = $new;
            $flash = "Added to cart: {$p['title']}";
        }
    }

    if ($action === 'update_cart' && !empty($_POST['productId'])) {
        $pid = intval($_POST['productId']);
        $qty = intval($_POST['qty'] ?? 0);
        if ($qty <= 0) unset($_SESSION['cart'][$pid]);
        else $_SESSION['cart'][$pid] = $qty;
        $flash = "Cart updated.";
    }

    if ($action === 'clear_cart') {
        $_SESSION['cart'] = [];
        $flash = "Cart cleared.";
    }

    if ($action === 'checkout') {
        $ordered = array_sum($_SESSION['cart']);
        $_SESSION['cart'] = [];
        $flash = "Checkout complete (Demo). Ordered: $ordered items.";
    }

    header("Location: " . strtok($_SERVER["REQUEST_URI"], '?'));
    exit;
}

// --- Get Products ---
$q = strtolower(trim($_GET['q'] ?? ''));
$category = $_GET['category'] ?? 'All';
$sort = $_GET['sort'] ?? 'featured';

$sql = "SELECT * FROM products WHERE 1";
if ($category !== 'All') $sql .= " AND category='" . mysqli_real_escape_string($conn, $category) . "'";
if ($q !== '') {
    $qesc = mysqli_real_escape_string($conn, $q);
    $sql .= " AND (title LIKE '%$qesc%' OR description LIKE '%$qesc%')";
}
if ($sort === 'price-asc') $sql .= " ORDER BY price ASC";
elseif ($sort === 'price-desc') $sql .= " ORDER BY price DESC";
elseif ($sort === 'stock') $sql .= " ORDER BY stock DESC";
else $sql .= " ORDER BY id DESC";

$products = mysqli_query($conn, $sql);

// --- Categories ---
$catRes = mysqli_query($conn, "SELECT DISTINCT category FROM products");
$cats = ['All'];
while ($row = mysqli_fetch_assoc($catRes)) $cats[] = $row['category'];

// --- Cart Items ---
$cartItems = [];
$cartTotal = 0;
foreach ($_SESSION['cart'] as $id => $qty) {
    $p = find_product($conn, $id);
    if ($p) {
        $p['qty'] = $qty;
        $cartItems[] = $p;
        $cartTotal += $p['price'] * $qty;
    }
}
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <title>Bikram Furniture — PHP + MySQL Store</title>
  <meta name="viewport" content="width=device-width,initial-scale=1" />
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-50 min-h-screen">
<div class="max-w-6xl mx-auto p-4 md:p-8">
  <header class="flex items-center justify-between">
    <div>
      <h1 class="text-2xl md:text-3xl font-bold">Bikram Furniture</h1>
      <p class="text-sm text-gray-600">Beautiful, handmade furniture — Database version</p>
    </div>
    <form method="get" class="flex items-center gap-2">
      <input name="q" value="<?=htmlspecialchars($_GET['q'] ?? '')?>" placeholder="Search..." class="border rounded px-3 py-2 w-60" />
      <select name="category" onchange="this.form.submit()" class="border rounded px-2 py-2">
        <?php foreach ($cats as $c): ?>
          <option value="<?=htmlspecialchars($c)?>" <?=$c==$category?'selected':''?>><?=htmlspecialchars($c)?></option>
        <?php endforeach; ?>
      </select>
      <select name="sort" onchange="this.form.submit()" class="border rounded px-2 py-2">
        <option value="featured" <?=$sort==='featured'?'selected':''?>>Featured</option>
        <option value="price-asc" <?=$sort==='price-asc'?'selected':''?>>Price Low → High</option>
        <option value="price-desc" <?=$sort==='price-desc'?'selected':''?>>Price High → Low</option>
        <option value="stock" <?=$sort==='stock'?'selected':''?>>Stock</option>
      </select>
    </form>
    <div class="border rounded p-2">
      <button onclick="document.getElementById('cart-panel').classList.toggle('hidden')">Cart (<?=array_sum($_SESSION['cart'])?>)</button>
    </div>
  </header>

  <?php if($flash): ?>
    <div class="mt-3 p-3 bg-green-50 border text-green-700 rounded"><?=htmlspecialchars($flash)?></div>
  <?php endif; ?>

  <main class="mt-6 grid grid-cols-1 lg:grid-cols-4 gap-6">
    <section class="lg:col-span-3">
      <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 gap-6">
        <?php while($p=mysqli_fetch_assoc($products)): ?>
          <article class="bg-white rounded shadow p-4 flex flex-col">
            <div class="h-44 bg-gray-100 rounded overflow-hidden flex items-center justify-center">
              <a href="product.php?id=<?=$p['id']?>">
                <img src="<?=htmlspecialchars($p['image'])?>" class="object-cover h-full w-full" />
              </a>
            </div>
            <h3 class="mt-3 font-semibold text-lg">
              <a href="product.php?id=<?=$p['id']?>" class="hover:underline">
                <?=htmlspecialchars($p['title'])?>
              </a>
            </h3>
            <p class="text-sm text-gray-600 flex-1"><?=htmlspecialchars(substr($p['description'],0,90))?>...</p>
            <div class="mt-2 flex justify-between items-center">
              <div>
                <div class="text-xl font-bold"><?=currencyINR($p['price'])?></div>
                <div class="text-xs text-gray-500">Stock: <?=$p['stock']?></div>
              </div>
              <form method="post">
                <input type="hidden" name="action" value="add_to_cart"/>
                <input type="hidden" name="productId" value="<?=$p['id']?>"/>
                <button type="submit" class="px-3 py-2 bg-indigo-600 text-white rounded">Add</button>
              </form>
            </div>
          </article>
        <?php endwhile; ?>
      </div>
    </section>

    <!-- Cart -->
    <aside id="cart-panel" class="lg:col-span-1 bg-white rounded shadow p-4">
      <h3 class="font-semibold">Cart</h3>
      <div class="mt-3 space-y-3">
        <?php if (empty($cartItems)): ?>
          <div class="text-gray-500">Cart empty.</div>
        <?php endif; ?>
        <?php foreach ($cartItems as $it): ?>
          <div class="flex items-center gap-3">
            <img src="<?=htmlspecialchars($it['image'])?>" class="w-12 h-12 object-cover rounded" />
            <div class="flex-1">
              <div class="text-sm font-medium"><?=htmlspecialchars($it['title'])?></div>
              <div class="text-xs text-gray-500"><?=currencyINR($it['price'])?> × <?=$it['qty']?></div>
            </div>
            <form method="post">
              <input type="hidden" name="action" value="update_cart"/>
              <input type="hidden" name="productId" value="<?=$it['id']?>"/>
              <input type="hidden" name="qty" value="0"/>
              <button class="text-red-500">×</button>
            </form>
          </div>
        <?php endforeach; ?>
      </div>
      <div class="mt-4 border-t pt-3">
        <div class="flex justify-between">
          <span>Total</span>
          <span class="font-bold"><?=currencyINR($cartTotal)?></span>
        </div>
        <form method="post" class="mt-3">
          <input type="hidden" name="action" value="checkout"/>
          <button class="w-full py-2 bg-green-600 text-white rounded">Checkout</button>
        </form>
      </div>
    </aside>
  </main>
</div>
</body>
</html>
