<?php
session_start();
include("config.php");

// --- Admin Login Check ---
if (!isset($_SESSION['admin_loggedin'])) {
    if ($_SERVER['REQUEST_METHOD'] == "POST" && isset($_POST['username'])) {
        $username = strtolower(trim($_POST['username'])); // case-insensitive
        $password = md5($_POST['password']); // simple hash

        $res = mysqli_query($conn, "SELECT * FROM admins WHERE username='$username' AND password='$password'");
        if (mysqli_num_rows($res) > 0) {
            $_SESSION['admin_loggedin'] = true;
            header("Location: admin.php");
            exit;
        } else {
            $error = "Invalid login!";
        }
    }
    ?>
    <!DOCTYPE html>
    <html>
    <head>
        <title>Admin Login</title>
        <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    </head>
    <body class="bg-gray-100 flex items-center justify-center h-screen">
        <form method="post" class="bg-white shadow-lg rounded-lg p-6 w-96">
            <h2 class="text-xl font-bold mb-4">Admin Login</h2>
            <?php if(isset($error)) echo "<p class='text-red-500'>$error</p>"; ?>
            <input type="text" name="username" placeholder="Username" required class="w-full border rounded px-3 py-2 mb-3">
            <input type="password" name="password" placeholder="Password" required class="w-full border rounded px-3 py-2 mb-3">
            <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded w-full">Login</button>
        </form>
    </body>
    </html>
    <?php
    exit;
}

// --- Add New Product ---
if (isset($_POST['add_product'])) {
    $title = $_POST['title'];
    $price = $_POST['price'];
    $category = $_POST['category'];
    $stock = $_POST['stock'];
    $desc = $_POST['description'];

    // ✅ File upload handling
    $image = "";
    if (!empty($_FILES['image']['name'])) {
        $targetDir = "uploads/"; // make sure folder exists and writable
        if (!is_dir($targetDir)) mkdir($targetDir, 0777, true);

        $fileName = time() . "_" . basename($_FILES['image']['name']);
        $targetFile = $targetDir . $fileName;

        if (move_uploaded_file($_FILES['image']['tmp_name'], $targetFile)) {
            $image = $targetFile;
        }
    }

    $query = "INSERT INTO products (title, price, category, image, stock, description) 
              VALUES ('$title','$price','$category','$image','$stock','$desc')";
    mysqli_query($conn, $query);
    $msg = "Product Added!";
}

// --- Delete Product ---
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    // delete old image also
    $old = mysqli_fetch_assoc(mysqli_query($conn, "SELECT image FROM products WHERE id=$id"));
    if ($old && file_exists($old['image'])) unlink($old['image']);
    mysqli_query($conn, "DELETE FROM products WHERE id=$id");
    header("Location: admin.php");
    exit;
}

$products = mysqli_query($conn, "SELECT * FROM products ORDER BY id DESC");
?>
<!DOCTYPE html>
<html>
<head>
    <title>Admin Panel - Furniture Store</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
</head>
<body class="bg-gray-100">
    <div class="max-w-6xl mx-auto p-6">
        <h1 class="text-2xl font-bold mb-4">Admin Panel</h1>

        <?php if(isset($msg)) echo "<div class='p-3 bg-green-100 text-green-700 mb-4'>$msg</div>"; ?>

        <!-- Add Product Form -->
        <form method="post" enctype="multipart/form-data" class="bg-white p-4 rounded shadow mb-6">
            <h2 class="font-semibold mb-3">Add New Product</h2>
            <input type="text" name="title" placeholder="Title" required class="w-full border px-3 py-2 mb-2">
            <input type="number" name="price" placeholder="Price" required class="w-full border px-3 py-2 mb-2">
            <input type="text" name="category" placeholder="Category" required class="w-full border px-3 py-2 mb-2">

            <!-- ✅ File Upload instead of URL -->
            <input type="file" name="image" accept="image/*" class="w-full border px-3 py-2 mb-2">

            <input type="number" name="stock" placeholder="Stock" required class="w-full border px-3 py-2 mb-2">
            <textarea name="description" placeholder="Description" class="w-full border px-3 py-2 mb-2"></textarea>
            <button type="submit" name="add_product" class="bg-green-600 text-white px-4 py-2 rounded">Add Product</button>
        </form>

        <!-- Products List -->
        <h2 class="font-semibold mb-3">All Products</h2>
        <table class="w-full bg-white rounded shadow">
            <tr class="bg-gray-200">
                <th class="p-2">Image</th>
                <th class="p-2">Title</th>
                <th class="p-2">Category</th>
                <th class="p-2">Price</th>
                <th class="p-2">Stock</th>
                <th class="p-2">Action</th>
            </tr>
            <?php while($row = mysqli_fetch_assoc($products)) { ?>
            <tr class="border-t">
                <td class="p-2">
                    <?php if($row['image']): ?>
                        <img src="<?=$row['image']?>" class="w-16 h-16 object-cover">
                    <?php else: ?>
                        <span class="text-gray-400">No Image</span>
                    <?php endif; ?>
                </td>
                <td class="p-2"><?=$row['title']?></td>
                <td class="p-2"><?=$row['category']?></td>
                <td class="p-2">₹<?=$row['price']?></td>
                <td class="p-2"><?=$row['stock']?></td>
                <td class="p-2">
                    <a href="admin.php?delete=<?=$row['id']?>" class="text-red-600">Delete</a>
                </td>
            </tr>
            <?php } ?>
        </table>
    </div>
</body>
</html>
